// Revision: 29 1.4.1.3 source/multmed/immmaud.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMMAUD_
   #define _IMMMAUD_
/*******************************************************************************
* FILE NAME: immmaud.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMMasterAudio                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <istdntfy.hpp>
#include <immdev.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMMasterAudioData;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMMasterAudio : public IStandardNotifier {
typedef IStandardNotifier
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMMasterAudio  ();

virtual
  ~IMMMasterAudio ();

/*-------------------------------- Setting Source ----------------------------*/
enum SettingSource
{
  saved   = 0x00004000L,
  current = 0x00008000L
};

/*----------------------------- Speakers -------------------------------------*/
virtual IMMMasterAudio
  &enableSpeakers      (bool enable = true, IMMDevice::CallType call = IMMDevice::wait),
  &disableSpeakers     (IMMDevice::CallType call = IMMDevice::wait),
  &saveSpeakersSetting (IMMDevice::CallType call = IMMDevice::wait);
bool
  areSpeakersEnabled   (SettingSource source = current,
                        IMMDevice::CallType call = IMMDevice::wait) const;

/*----------------------------- Headphones -----------------------------------*/
virtual IMMMasterAudio
  &enableHeadphones      (bool enable = true, IMMDevice::CallType call = IMMDevice::wait),
  &disableHeadphones     (IMMDevice::CallType call = IMMDevice::wait),
  &saveHeadphonesSetting (IMMDevice::CallType call = IMMDevice::wait);
bool
  areHeadphonesEnabled (SettingSource source = current,
                        IMMDevice::CallType call = IMMDevice::wait) const;

/*----------------------------- Volume ---------------------------------------*/
virtual IMMMasterAudio
  &setVolume  (unsigned long volume , IMMDevice::CallType call = IMMDevice::wait),
  &saveVolume (IMMDevice::CallType call = IMMDevice::wait);
unsigned long
  volume      (SettingSource source = current,
               IMMDevice::CallType call = IMMDevice::wait) const;
private:
/*--------------------------------- Private ----------------------------------*/
IMMMasterAudioData*
  fMasterAudioData;


// Explicit copy CTOR, to avoid default inlining by compiler.
IMMMasterAudio  (const IMMMasterAudio& device);

}; // IMMMasterAudio

#endif /* IC_PMWIN */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMMAUD_ */
