// Revision: 27 1.3.1.3 source/multmed/immfilem.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMFILEM_
   #define _IMMFILEM_
/*******************************************************************************
* FILE NAME: immfilem.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMFileMedia                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immplayd.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_WIN
class IMMDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMFileMedia : public IMMPlayableDevice {
typedef IMMPlayableDevice
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
  ~IMMFileMedia();

/*------------------------------- File Loading -------------------------------*/
virtual IMMFileMedia
  &load         (const IString& filename,
                 bool readOnly = false,
                 CallType call = wait),
  &loadOnThread (const IString& filename,
                 bool readOnly = false);

IString
  filename      (CallType call = wait) const;

virtual bool
  isWriteable   () const;

#ifdef IC_WIN
/*-------------------------- Device open overrides ---------------------------*/
virtual IMMFileMedia
  &open              (const IString& fileOrDevice = IString(),
                      bool shareable = true,
                      CallType call = wait),
  &openOnThread      (const IString& fileOrDevice = IString(),
                      bool shareable = true,
                      CallType call = wait);
#endif

protected:
/*------------------------------- Constructors -------------------------------*/
  IMMFileMedia ( const IString& deviceName,
                 bool openNow,
                 unsigned long instance,
                 bool openShareable);

  IMMFileMedia ( unsigned long deviceIdentifier,
                 const IString& newAlias = IString());

/*---------------------------- Read Only Operations --------------------------*/
virtual IMMFileMedia
  &enableDataUpdate  ( bool update=true );

#ifdef IC_WIN
/*-------------------------- Device open overrides ---------------------------*/
virtual IMMFileMedia
  &open                   (unsigned long instanceNumber,
                           bool shareable = true,
                           CallType call = nowait),
  &openOnThread           (unsigned long instanceNumber,
                           bool shareable = true);

/*-------------------------------- Implementation ----------------------------*/
virtual IMMFileMedia
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMMFileMedia          ( const IMMFileMedia& device );
IMMFileMedia
 &operator=             ( const IMMFileMedia& device );

/*--------------------------------- Private ----------------------------------*/
bool
  fWriteable;

#ifdef IC_WIN
IMMDeviceSettings
  *fDeviceSettings ;
#endif

}; // IMMFileMedia

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMFILEM_ */
