// Revision: 25 1.4.1.3 source/multmed/immexcpt.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMEXCPT_
#define _IMMEXCPT_
/*******************************************************************************
* FILE NAME: immexcpt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMErrorInfo                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <iexcept.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMErrorInfo : public IBaseErrorInfo {
typedef IBaseErrorInfo
  Inherited;

public:
/*------------------------ Constructor ---------------------------------------*/
  IMMErrorInfo  ( unsigned long errorId = 0,
                  const char* functionName = 0 );
virtual
  ~IMMErrorInfo ( );

/*-------------------------------- Accessors ---------------------------------*/
virtual operator const char* () const;

virtual const char
 *text        ( ) const;
virtual unsigned long
  errorId     ( ) const;
virtual bool
  isAvailable ( ) const;

/*------------------------------ Throw Support -------------------------------*/
static void
  throwMMError  ( unsigned long             errorId,
                  const char*               functionName,
                  const IExceptionLocation& location,
                  IBaseErrorInfo::ExceptionType name = accessError,
                  IException::Severity      severity = IException::recoverable );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
    ulClErrorId;
bool
    foundText;
char
 *pClFuncNameText;

/*--------------------------------- Hidden Functions -------------------------*/
  IMMErrorInfo ( const IMMErrorInfo& errorInformation );
IMMErrorInfo
  &operator=   ( const IMMErrorInfo& errorInformation );

}; // IMMErrorInfo


#define ITHROWMMERROR(errorId,func)\
    IMMErrorInfo::throwMMError(errorId, func, IEXCEPTION_LOCATION())

#define ITHROWMMERROR2(errorId, func, exType, sev)\
    IMMErrorInfo::throwMMError(errorId, func, IEXCEPTION_LOCATION(), exType, sev)

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMEXCPT_ */
