// Revision: 21 1.4.1.3 source/multmed/immdvhdr.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMDVHDR_
   #define _IMMDVHDR_
/*******************************************************************************
* FILE NAME: immdvhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IMMDeviceHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMDevice;
class IMMCuePointEvent;
class IMMDeviceEvent;
class IMMPassDeviceEvent;
class IMMPositionChangeEvent;
class IMMNotifyEvent;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMDeviceHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMDeviceHandler();
virtual
  ~IMMDeviceHandler();

/*---------------------------- Device Attachment -----------------------------*/
virtual IMMDeviceHandler
 &handleEventsFor       ( IMMDevice* device ),
 &stopHandlingEventsFor ( IMMDevice* device );

/*-------------------------------- Event Processing --------------------------*/
virtual bool
#ifndef IC_WIN_FLAGNOP
  cuePoint        (const IMMCuePointEvent&   event),
  passDevice      (const IMMPassDeviceEvent& event),
#endif
  deviceEvent     (const IMMDeviceEvent&     event),
  positionChange  (const IMMPositionChangeEvent& event);

protected:
/*----------------------------- Notification ---------------------------------*/
virtual bool
  dispatchHandlerEvent    (IEvent& event);

private:
/*--------------------------------- Private ----------------------------------*/
// Explicit copy CTOR, to avoid default inlining by compiler.
IMMDeviceHandler  (const IMMDeviceHandler&);

virtual IMMDeviceHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

}; // IMMDeviceHandler

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMDVHDR_ */
