// Revision: 19 1.4.1.3 source/multmed/immdigvd.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMDIGVD_
   #define _IMMDIGVD_
/*******************************************************************************
* FILE NAME:  immdigvd.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMDigitalVideo                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immaud.hpp>
#include <istring.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMSpeed;
class IWindowHandle;
class IWindow;
#ifdef IC_WIN
class IMMDVDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMDigitalVideo : public IMMConfigurableAudio {
typedef IMMConfigurableAudio
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMDigitalVideo  ( bool openNow = true,
                     unsigned long instance = 0,
                     bool openShareable = true );
virtual
  ~IMMDigitalVideo ();

/*-------------------------------- Playback Speeds ---------------------------*/
IMMSpeed
#ifdef IC_PM
  fastSpeed         (CallType call = wait) const,
#endif
  maximumSpeed      (CallType call = wait) const,
  minimumSpeed      (CallType call = wait) const,
  normalSpeed       (CallType call = wait) const,
#ifdef IC_PM
  slowSpeed         (CallType call = wait) const,
#endif
  speed             (CallType call = wait) const,
  fileNormalSpeed   (CallType call = wait) const;

/*-------------------------------- Capabilities ------------------------------*/
bool
  supportsSizing          (CallType call = wait) const,
  supportsReverse         (CallType call = wait) const,
  supportsStretchToFit    (CallType call = wait) const,
  supportsOverlayGraphics (CallType call = wait) const;

/*-------------------------- Playback ----------------------------------------*/
bool
  isPlayingForward (CallType call = wait) const;

#ifdef IC_WIN
virtual IMMDigitalVideo
  &play            (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    bool resumeIfPaused = true,
                    CallType call = nowait) ;
#endif

IMMDigitalVideo
  &playAt          (const IMMSpeed& speed,
                    const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait),
  &playFast        (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait),
  &playScan        (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait),
  &playSlow        (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait);

/*-------------------------- Record and Monitoring ---------------------------*/
virtual IMMDigitalVideo
  &record             ( const IMMTime& end   = IMMTime(),
                        bool resumeIfPaused = true,
                        CallType call = nowait ) ;
#ifdef IC_PM
virtual IMMDigitalVideo
  &enableMonitoring   ( bool enable= true,
                        CallType call = wait ),
  &disableMonitoring  ( CallType call = wait );

bool
  isMonitoringEnabled ( CallType call = wait) const;

IWindowHandle
  monitorHandle       (CallType call = wait) const;

IMMDigitalVideo
  &setMonitorWindow   (const IWindowHandle& handle, CallType call = wait),
  &setMonitorWindow   (const IWindow& window, CallType call = wait),
  &useDefaultMonitorWindow  (CallType call = wait);
#endif

/*-------------------------- Video Window ------------------------------------*/
unsigned long
  videoWidth         (CallType call = wait) const,
  videoHeight        (CallType call = wait) const;
unsigned long
  maximumWindows     (CallType call = wait) const ;
unsigned long
  videoFileWidth     (CallType call = wait) const,
  videoFileHeight    (CallType call = wait) const;

IRectangle
  sourceRectangle    (CallType call = wait) const,
  destinationRectangle(CallType call = wait) const;

IMMDigitalVideo
  &setDestination    (const IRectangle& rectangle, CallType = wait),
  &setWindow         (const IWindowHandle& handle, CallType call = wait),
  &setWindow         (const IWindow& window, CallType call = wait),
  &useDefaultWindow  (CallType call = wait) ;

#ifdef IC_PM
IMMDigitalVideo
  &refresh           (const IRectangle& source = IRectangle(),
                      const IRectangle& destination = IRectangle(),
                      CallType call = wait);
#endif

IWindowHandle
  handle             (CallType call = wait) const;
IString
  videoFileName      () const;


protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMDigitalVideo ( unsigned long deviceIdentifier,
                    const IString& newAlias);

/*-------------------------------- Implementation ----------------------------*/
IMMDigitalVideo
  &playDigital       (const IMMTime& from = IMMTime(),
                      const IMMTime& to   = IMMTime(),
                      CallType call = nowait,
                      unsigned long flags = 0,
                      unsigned long speed = 0);
#ifdef IC_PM
virtual unsigned long
  translateAudioFlag (unsigned long) const;
#endif

virtual bool
  isOpenStringValid  (const IString& deviceName) const;

#ifdef IC_WIN
virtual IMMDigitalVideo
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMDigitalVideo       ( const IMMDigitalVideo& device );
IMMDigitalVideo
 &operator=             ( const IMMDigitalVideo& device );
virtual IMMDigitalVideo
  &record          (bool insert ,
                    const IMMTime& begin,
                    const IMMTime& end,
                    bool resumeIfPaused,
                    CallType call = nowait);
#ifdef IC_WIN
IMMDigitalVideo
  &setSpeed(const unsigned long = 1000) ;
unsigned long
  getSpeedFactor(const IMMSpeed) const ;
IMMDVDeviceSettings
  *fDeviceSettings ;
#endif

}; // IMMDigitalVideo

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMDIGVD_ */
