// Revision: 15 1.4.1.3 source/multmed/immdev.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMDEV_
   #define _IMMDEV_
/*******************************************************************************
* FILE NAME:  immdev.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMDevice                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <istdntfy.hpp>
#include <ipoint.hpp>
#include <immtime.hpp>
#include <immevt.hpp>
#include <immspeed.hpp>
#include <inotify.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMDeviceHandler;
class IMMDeviceNotifyHandler;
class IMMDeviceData;
class IMMMessageWindow;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMDevice : public IStandardNotifier {
typedef IStandardNotifier
  Inherited;
public:
/*-------------------------------- Constructors ------------------------------*/
virtual
  ~IMMDevice();

/*-------------------------------- Call Type ---------------------------------*/
enum CallType
{
  nowait = 0X00000001,
  wait   = 0x00000002
};

/*-------------------------------- Device Type and Description ---------------*/
static const unsigned long
  IC_IMPORTM cdxa,
  IC_IMPORTM audioCD,
  IC_IMPORTM dat,
  IC_IMPORTM audioTape,
  IC_IMPORTM waveAudio,
  IC_IMPORTM sequencer,
  IC_IMPORTM ampMixer,
  IC_IMPORTM videoTape,
  IC_IMPORTM digitalVideo,
  IC_IMPORTM videoDisc,
  IC_IMPORTM overlay,
  IC_IMPORTM animation,
  IC_IMPORTM speaker,
  IC_IMPORTM headphone,
  IC_IMPORTM microphone,
  IC_IMPORTM monitor,
  IC_IMPORTM other,
  IC_IMPORTM allDevices;

unsigned long
  deviceType    (CallType call = wait) const;
IString
  description        (CallType call = wait) const;

#ifdef IC_PM
/*-------------------------------- Preroll Type ------------------------------*/
enum PrerollType
{
   variable = 1,
   fixed,
   none
};
PrerollType
  prerollType       (CallType call = wait) const;
IMMTime
  prerollTime       (CallType call = wait) const;
#endif /* IC_PM */

/*------------------------------- Capabilities -------------------------------*/
bool
  supportsVolumeAdjustment(CallType call = wait) const,
  supportsRecordInsertion(CallType call = wait) const,
  supportsDisableEject   (CallType call = wait) const,
  supportsDigitalTransfer(CallType call = wait) const,
  supportsStreaming      (CallType call = wait) const,
  supportsCommand        (IMMNotifyEvent::Command command,
                          CallType call = wait) const,
  supportsEject          (CallType call = wait) const,
  supportsPlay           (CallType call = wait) const,
  supportsRecord         (CallType call = wait) const,
  supportsSave           (CallType call = wait) const,
  supportsAudio          (CallType call = wait) const,
  supportsVideo          (CallType call = wait) const,
  requiresFiles          (CallType call = wait) const;

/*-------------------------------- Share Mode & Acquire ----------------------*/
enum ShareMode
{
  shareable,
  isolatedExclusive = 0x00000100,
  exclusive         = 0x00000200
};
virtual IMMDevice
  &acquire   (ShareMode acquire = shareable,
              bool queuedForResources = false,
              CallType call = wait),
  &release   (CallType call = wait);
bool
  isAcquired (CallType call = wait) const;

/*-------------------------------- Event Type and DeleteEvents ---------------*/
enum EventType
{
  allEvents,
  notifyEvent = 0x0500,
  passDeviceEvent,
  positionChangeEvent,
  cuePointEvent,
  deviceEvent,
  synchEvent
};
virtual IMMDevice
  &deletePendingEvents (EventType event = allEvents);

/*-------------------------------- Open and Close ----------------------------*/
virtual IMMDevice
  &close             (CallType call = wait),
  &open              (const IString& fileOrDevice = IString(),
                      bool shareable = true,
                      CallType call = wait),
  &openOnThread      (const IString& fileOrDevice = IString(),
                      bool shareable = true,
                      CallType call = wait);
IMMDevice
  &setCloseOnDestroy (bool close = true);
bool
  isOpen             () const,
  isCloseOnDestroy   () const;

/*-------------------------------- Mode --------------------------------------*/
enum Mode
{
  notReady  = 1,
  paused,
  playing,
  stopped,
  recording,
  seeking
};
virtual Mode
  mode  (CallType call = wait) const;

/*-------------------------------- Audio -------------------------------------*/
enum AudioChannel
{
  all,
  left,
  right
};
virtual IMMDevice
  &setVolume   (unsigned long volume,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait),
  &enableAudio (bool enable= true,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait),
  &disableAudio(AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait);
virtual unsigned long
  volume       (AudioChannel channel = left,
                CallType call = wait) const;
bool
  isAudioEnabled(AudioChannel channel = all,
                 CallType call = wait);

/*-------------------------------- Speed and Time ----------------------------*/
IMMSpeed::Format
  speedFormat     (CallType call = wait) const;
virtual IMMDevice
  &setSpeedFormat (IMMSpeed::Format format, CallType call = wait),
  &setTimeFormat  (IMMTime::Format format, CallType call = wait);
IMMTime::Format
  timeFormat      (CallType call = wait) const;

/*-------------------------------- Connector Type ----------------------------*/
#ifndef IC_WIN_FLAGNOP
enum ConnectorType
{
  midiStream = 0x00000001,
  cdStream   = 0x00000002,
  waveStream = 0x00000003,
  ampStream  = 0x00000004,
  xaStream   = 0x00000005,
  headphones = 0x00000006,
  speakers   = 0x00000007,
  microphones= 0x00000008,
  lineIn     = 0x00000009,
  lineOut    = 0x0000000a,
  videoIn    = 0x0000000b,
  videoOut   = 0x0000000c,
  phoneSet   = 0x0000000d,
  phoneLine  = 0x0000000e,
  audioIn    = 0x0000000f,
  audioOut   = 0x00000010,
  universal  = 0x00000011
};
virtual IMMDevice
  &enableConnector      (ConnectorType type,
                         bool enable=true,
                         CallType call = wait),
  &disableConnector     (ConnectorType type,
                         CallType call = wait);
bool
  isConnectionSupported (ConnectorType type,
                         CallType call = wait) const,
  isConnectorEnabled    (ConnectorType type,
                         CallType call = wait) const;
unsigned long
  connectedDeviceId     (ConnectorType type,
                         CallType call = wait) const;
#endif

/*---------------------------- Device Information ----------------------------*/
unsigned long
  deviceId        () const;
IString
  aliasName       () const,
  deviceName      () const;

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTM commandNotifyId,
  IC_IMPORTM passDeviceId,
  IC_IMPORTM cuePointId,
  IC_IMPORTM positionChangeId,
  IC_IMPORTM deviceEventId;

/*----------------------- Observer Notification ------------------------------*/
virtual IMMDevice
 &enableNotification (bool enabled = true);

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMDevice ( const IString& fileOrDevice );
  IMMDevice ( unsigned long deviceIdentifier,
              const IString& newAlias = IString());

/*------------------- Observer Notification Implementation -------------------*/
IMMDevice
 &setNotificationHandler ( IMMDeviceNotifyHandler* notifyHandler );

IMMDeviceNotifyHandler
 *notificationHandler    ( ) const;


/*-------------------------------- Open Status -------------------------------*/
enum OpenStatus
{
  openNotAttempted,
  openSuccessful,
  openFailed
};

OpenStatus
  openStatus     () const;
IMMDevice
  &setOpenStatus (OpenStatus status);

/*-------------------- Implementation ----------------------------------------*/
unsigned long
  itemStatus              (unsigned long item,
                           unsigned long value = 0,
                           CallType call = wait) const,
  itemCapability          (unsigned long item, CallType call) const;
IString
   sendCommand            (const IString& command),
   sendCommand            (const IString& command,unsigned short userParm);
IMMDevice
  &sendCommand            (unsigned short message, unsigned long param1,
                           void *param2),
  &sendCommand            (unsigned short message, unsigned long param1,
                           void *param2, unsigned short userParm),
  &setPassDeviceRequested (bool sawPassDevice),
  &setUserParameter       (unsigned short userParm = 0);
IMMMessageWindow
  &deviceWindow() const;
bool
  wasPassDeviceRequested  () const;
unsigned short
  userParameter           () const;

virtual bool
  isOpenStringValid       (const IString& deviceName) const;

virtual IMMDevice
  &open                   (unsigned long instanceNumber,
                           bool shareable = true,
                           CallType call = nowait),
  &openOnThread           (unsigned long instanceNumber,
                           bool shareable = true);

#ifdef IC_WIN

virtual IMMDevice
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);

/*-------------------- Mixer Controls ----------------------------------------*/
unsigned long
  systemMixerHandle       () const;

IMMDevice
  &setSystemMixerHandle   (unsigned long hmx);

virtual bool
  mixerControlValues      (unsigned long dwComponentType,
                           unsigned long dwControlType,
                           unsigned long *ulDetails,
                           bool  uniform = true,
                           unsigned long multipleItems = 0,
                           unsigned long hmx = NULL),

  mixerControlValues      (unsigned long dwComponentType,
                           unsigned long dwControlType,
                           unsigned short *usDetails,
                           bool  uniform = true,
                           unsigned long multipleItems = 0,
                           unsigned long hmx = NULL),

  setMixerControlValues   (unsigned long dwComponentType,
                           unsigned long dwControlType,
                           unsigned long *ulDetails,
                           bool  uniform = true,
                           unsigned long multipleItems = 0,
                           unsigned long hmx = NULL),

  setMixerControlValues   (unsigned long dwComponentType,
                           unsigned long dwControlType,
                           unsigned short *usDetails,
                           bool  uniform = true,
                           unsigned long multipleItems = 0,
                           unsigned long hmx = NULL);
#endif

/*---------------------------- Error Information -----------------------------*/
unsigned long
  lastError      () const;
IMMDevice
  &setLastError  (unsigned long errorId);

private:
/*--------------------------------- Private ----------------------------------*/
// Explicit copy and default CTORs, to avoid default inlining by compiler.
IMMDevice (const IMMDevice& device);

void
  establishAlias (),
  releaseAlias   (const IString& alias);
IString
  uniqueAlias    ();

#ifdef IC_WIN
unsigned short
  firstUnacknowledgedCommand() ;
#endif

IMMDeviceData
  *fDeviceData;

friend class IMMDeviceHandler;
friend class IMMDeviceData;
}; // IMMDevice

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMDEV_ */
