// Revision: 12 1.3.1.3 source/multmed/immcdxa.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMCDXA_
   #define _IMMCDXA_
/*******************************************************************************
* FILE NAME: immcdxa.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMCDXA                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immremed.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMCDXA : public IMMRemovableMedia {
typedef IMMRemovableMedia
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMCDXA ( bool openNow = true,
            unsigned long instance = 0,
            bool openShareable = true);

virtual
  ~IMMCDXA();

/*-------------------------------- UPC ---------------------------------------*/
IString
  upc    (CallType call = wait) const;

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMCDXA ( unsigned long deviceIdentifier,
            const IString& newAlias = IString());

/*-------------------------------- Implementation ----------------------------*/
virtual bool
  isOpenStringValid(const IString& deviceName) const;

}; // IMMCDXA

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMCDXA_ */
