// Revision: 07 1.3.1.3 source/multmed/immaud.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMAUD_
   #define _IMMAUD_
/*******************************************************************************
* FILE NAME:  immaud.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMConfigurableAudio                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immrecrd.hpp>
#include <istring.hpp>
#include <immabuf.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_WIN
class IMMDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMConfigurableAudio : public IMMRecordable {
typedef IMMRecordable
  Inherited;
public:
/*-------------------------- Constructor -------------------------------------*/
virtual
  ~IMMConfigurableAudio();

/*----------------------------- Audio Attributes -----------------------------*/
unsigned long
  bytesPerSecond        (CallType call = wait) const,
  bitsPerSample         (CallType call = wait) const,
  blockAlignment        (CallType call = wait) const,
  channels              (CallType call = wait) const,
  samplesPerSecond      (CallType call = wait) const;

IMMAudioBuffer::Format
  format                (CallType call = wait) const;

virtual IMMConfigurableAudio
  &setBytesPerSecond    (unsigned long averageBytes,
                         CallType call = wait),
  &setBitsPerSample     (unsigned long bitsPerSample,
                         CallType call = wait),
  &setBlockAlignment    (unsigned long alignment,
                         CallType call = wait),
  &setChannels          (unsigned long channels,
                         CallType call = wait),
  &setFormat            (IMMAudioBuffer::Format tag = IMMAudioBuffer::pcm,
                         CallType call = wait),
  &setSamplesPerSecond  (unsigned long samplesPerSecond,
                         CallType call = wait);

#ifdef IC_WIN
/*----------------------------- Audio Overrides -----------------------------*/
virtual IMMConfigurableAudio
  &setVolume   (unsigned long volume,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait);
virtual unsigned long
  volume       (AudioChannel channel = left,
                CallType call = wait) const;
#endif

protected:
/*------------------------- Constructors -------------------------------------*/
  IMMConfigurableAudio ( const IString& deviceName,
                         bool openNow = true,
                         unsigned long instance = 0,
                         bool openShareable = true );
  IMMConfigurableAudio ( unsigned long deviceIdentifier,
                         const IString& newAlias = IString() );

/*----------------------------- Implementation -------------------------------*/
virtual unsigned long
  translateAudioFlag(unsigned long) const;

#ifdef IC_WIN
virtual IMMConfigurableAudio
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMConfigurableAudio  ( const IMMConfigurableAudio& device );
IMMConfigurableAudio
 &operator=             ( const IMMConfigurableAudio& device );

#ifdef IC_WIN
IMMDeviceSettings
  *fDeviceSettings ;
#endif

}; // IMMConfiguableAudio

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMAUD_ */
