// Revision: 05 1.3.1.3 source/multmed/immamix.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMAMIX_
   #define _IMMAMIX_
/*******************************************************************************
* FILE NAME: immamix.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IMMAmpMixer                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immdev.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMAmpMixer : public IMMDevice {
typedef IMMDevice
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMAmpMixer  (bool openNow = true,
                unsigned long instance = 0, bool openShareable = true);
  IMMAmpMixer  (unsigned long deviceIdentifier,
                const IString& newAlias = IString());

virtual
  ~IMMAmpMixer ();

/*----------------------------- Mixer Attributes -----------------------------*/
unsigned long
  balance        (CallType call = wait) const,
  bass           (CallType call = wait) const,
  gain           (CallType call = wait) const,
  pitch          (CallType call = wait) const,
  treble         (CallType call = wait) const;
virtual IMMAmpMixer
  &setBalance    (unsigned long balance, CallType call = wait),
  &setBass       (unsigned long bass, CallType call = wait),
  &setGain       (unsigned long gain, CallType call = wait),
  &setPitch      (unsigned long pitch, CallType call = wait),
  &setTreble     (unsigned long treble, CallType call = wait);

/*----------------------------- Monitoring -----------------------------------*/
virtual IMMAmpMixer
  &enableMonitoring   (bool enable= true, CallType call = wait),
  &disableMonitoring  (CallType call = wait);
bool
  isMonitoringEnabled (CallType call = wait) const;

#ifdef IC_WIN
/*-------------------------- Device open/close overrides ---------------------*/
virtual IMMAmpMixer
  &open              (const IString& fileOrDevice = IString(),
                      bool shareable = true,
                      CallType call = wait),
  &openOnThread      (const IString& fileOrDevice = IString(),
                      bool shareable = true,
                      CallType call = wait);
virtual IMMAmpMixer
  &close             (CallType call = wait);
#endif

protected:
/*-------------------------------- Implementaion -----------------------------*/
virtual bool
  isOpenStringValid(const IString& deviceName) const;

#ifdef IC_WIN
/*-------------------------- Device open overrides ---------------------------*/
virtual IMMAmpMixer
  &open                   (unsigned long instanceNumber,
                           bool shareable = true,
                           CallType call = nowait),
  &openOnThread           (unsigned long instanceNumber,
                           bool shareable = true);
#endif
}; // IMMAmpMixer

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMAMIX_ */
