// Revision: 03 1.3.1.3 source/multmed/immabuf.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMABUF_
   #define _IMMABUF_
/*******************************************************************************
* FILE NAME:  immabuf.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMAudioBuffer                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <immpl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMAudioBufferData;
class IString;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMAudioBuffer  {
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMAudioBuffer  ( void* audioData,
                    unsigned long dataLength );
  IMMAudioBuffer  ( unsigned long dataLength = 0 );
  IMMAudioBuffer  ( const IMMAudioBuffer& audioBuffer );

IMMAudioBuffer
  &operator =     ( const IMMAudioBuffer& audioBuffer );

  ~IMMAudioBuffer ( );
/*-------------------------------- Format ------------------------------------*/
enum Format
{
  pcm      = 0x0001,
  adpcm,
  ibmcvsd  = 0x0005,
  alaw,
  mulaw,
  okiadpcm = 0x0010,
  dviadpcm,
  digistd  = 0x0015,
  digifix,
  ibmmulaw = 0x0101,
  ibmalaw,
  avcadpcm,
  ctadpcm  = 0x0200
};

#ifdef IC_PM
Format
  format             () const;
IMMAudioBuffer
  &setFormat         ( Format tag = pcm );

/*----------------------------- Buffer Management ----------------------------*/
IString
  data                () const;
IMMAudioBuffer
  &setData            ( const void* data,
                        unsigned long dataLength);
unsigned long
  length              () const;

IString
   headerData          () const;

/*-------------------------------- Content Type ------------------------------*/
enum ContentType
{
  Unknown,
  Voice,
  Music,
  HiFi    = 0x0004
};

ContentType
  contentType           () const;

IMMAudioBuffer
  &setContentType       ( ContentType contentType );

/*-------------------------------- Audio Attributes --------------------------*/

unsigned long
  bytesPerSecond        () const,
  bitsPerSample         () const,
  blockAlignment        () const,
  channels              () const,
  samplesPerSecond      () const;


IMMAudioBuffer
  &setBytesPerSecond    ( unsigned long averageBytes ),
  &setBitsPerSample     ( unsigned long bitsPerSample ),
  &setBlockAlignment    ( unsigned long alignment ),
  &setChannels          ( unsigned long channels ),
  &setSamplesPerSecond  ( unsigned long samplesPerSecond );

/*--------------------------------- media Type -------------------------------*/
static const unsigned long
  IC_IMPORTM audio;

unsigned long
  mediaType             () const;

IMMAudioBuffer
  &setMediaType         ( unsigned long media = audio );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
IString
  *fBuffer;
void
  *fHeader;
unsigned long
  fLength;
IMMAudioBufferData
  *fAudioBufferData;

}; // IMMAudioBuffer

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMABUF_ */
