// Revision: 13 1.8.1.4 source/ui/basectl/imle.hpp, editctls, ioc.v400, 980918 
#ifndef _IMLE_
  #define _IMLE_
/*******************************************************************************
* FILE NAME: imle.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMultiLineEdit                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IWindowHandle;
class IFont;
class IColor;
class IMultiLineEditData;

#pragma enum(4)
#pragma pack(push,4)

class IMultiLineEdit : public ITextControl {
typedef ITextControl
  Inherited;

public:
class Style;
/*------------------------------ Constructors --------------------------------*/
  IMultiLineEdit ( unsigned long     id,
                   IWindow*          parent,
                   IWindow*          owner,
                   const IRectangle& initial= IRectangle(),
                   const Style&      style = defaultStyle() );

  IMultiLineEdit ( unsigned long     id,
                   IWindow*          parent );

  IMultiLineEdit ( const IWindowHandle& handle );

virtual
 ~IMultiLineEdit ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IMultiLineEdit, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU border,
  IC_IMPORTU readOnly,
  IC_IMPORTU wordWrap,
  IC_IMPORTU horizontalScroll,
  IC_IMPORTU verticalScroll,
  IC_IMPORTU ignoreTab,
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*-------------------------------- Change Operations -------------------------*/
virtual IMultiLineEdit
 &setTextChangedFlag    ( bool changed=true ),
 &resetTextChangedFlag  ( );
bool
  hasTextChanged        ( ) const;

/*-------------------------------- Read-Only Operations ----------------------*/
virtual IMultiLineEdit
  &disableDataUpdate  ( ),
  &enableDataUpdate   ( bool update=true );

bool
  isWriteable         ( ) const;

/*-------------------------------- Refresh Operations ------------------------*/
virtual IMultiLineEdit
 &enableUpdate        ( bool update=true ),
 &disableUpdate       ( );

/*-------------------------------- Text Operations ---------------------------*/
enum EOLFormat {
  cfText,
  noTran,
  MLEFormat
};

virtual IString
  text         ( ) const,
  text         ( unsigned long lineNumber ) const;
unsigned long
  limit        ( ) const;
virtual unsigned long
  textLength   ( ) const;
virtual IMultiLineEdit
  &setText     ( const char* text ),
  &setText     ( const IResourceId& text ),
  &setText     ( const char* buffer,
                 unsigned long bufferSize ),
  &setLimit    ( unsigned long newLimit );

virtual IMultiLineEdit
  &add         ( const char* text,
                 unsigned long textSize=0,
                 EOLFormat type=cfText ),
  &addAsLast   ( const char* text,
                 unsigned long textSize=0,
                 EOLFormat type=cfText ),
  &addAtOffset ( const char* text,
                 unsigned long offset,
                 unsigned long textSize=0,
                 EOLFormat type=cfText );

/*-------------------------------- Import/Export Operations ------------------*/
virtual unsigned long
  importFromFile           ( const char* fileName,
                             EOLFormat type=cfText ),
  exportToFile             ( const char* fileName,
                             EOLFormat type=cfText ),
  exportSelectedTextToFile ( const char* fileName,
                             EOLFormat type=cfText );

/*-------------------------------- Selected Text -----------------------------*/
static const long
  IC_IMPORTU deselect,
  IC_IMPORTU end;
virtual IMultiLineEdit
 &selectRange        ( const IRange& range=IRange(0,end),
                       unsigned long timestamp=0 );
virtual IRange
  selectedRange      ( ) const;
virtual IString
  selectedText       ( ) const;
virtual unsigned long
  selectedTextLength ( ) const;
virtual bool
  hasSelectedText    ( ) const;

/*-------------------------------- Clipboard Operations ----------------------*/
virtual IMultiLineEdit
 &cut     ( unsigned long timestamp=0 ),
 &copy    ( unsigned long timestamp=0 ),
 &paste   ( ),
 &clear   ( unsigned long timestamp=0 ),
 &discard ( );

/*-------------------------------- Undo Operations ---------------------------*/
#ifndef IC_MOTIF_FLAGNOP
bool
  isUndoable ( ) const;
virtual IMultiLineEdit
 &undo       ( );
#endif

/*-------------------------------- Delete Text Operation ---------------------*/
virtual IMultiLineEdit
 &removeAll  ( );

/*-------------------------------- Size Operations ---------------------------*/
virtual IMultiLineEdit
 &setEditRegion       ( ),
 &setEditRegion       ( const ISize& sizeEditRegion ),
 &setEditRegionWidth  ( long width ),
 &setEditRegionHeight ( long height );
unsigned long
  editRegionWidth     ( ) const,
  editRegionHeight    ( ) const;

/*-------------------------------- Tab Stop Operation ------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IMultiLineEdit
 &setTab              ( unsigned long tabPixelInterval );
#endif

/*---------------------------- Word Wrap Operations --------------------------*/
bool
  isWordWrap      ( ) const;
#ifndef IC_WIN_FLAGNOP
virtual IMultiLineEdit
 &enableWordWrap  ( bool enable=true ),
 &disableWordWrap ( );
#endif

/*---------------------------------- Colors ----------------------------------*/
#if ( !defined(IC_MOTIF) && !defined(IC_WIN_FLAGNOP) )
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;
#endif //!IC_MOTIF and !IC_WIN_FLAGNOP

/*---------------------------------- Fonts -----------------------------------*/
#ifdef IC_PM
virtual IMultiLineEdit
 &setFont         ( const IFont& font );
#endif

/*-------------------------------- Line Operations ---------------------------*/
virtual IMultiLineEdit
 &addLine               ( const char*   text,
                          unsigned long lineNumber,
                          EOLFormat     type=cfText ),
 &addLineAsLast         ( const char*   text,
                          EOLFormat     type=cfText ),
 &removeLine            ( unsigned long lineNumber ),
 &setCursorLinePosition ( unsigned long lineNumber ),
 &setCursorPosition     ( unsigned long cursorPosition ),
 &setTop                ( unsigned long lineNumber );

unsigned long
  cursorLinePosition ( ) const,
  cursorPosition     ( ) const,
  top                ( ) const,
  numberOfLines      ( ) const,
  visibleLines       ( ) const;

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU dataUpdateId,
  IC_IMPORTU limitId;

/*----------------------- Observer Notification ------------------------------*/
virtual IMultiLineEdit
 &enableNotification ( bool enable = true );


protected:
/*---------------------- Event-Handling Implementation -----------------------*/
#ifdef IC_MOTIF
virtual bool
  passEventToOwner    ( IEvent &event );
#endif // IC_MOTIF

/*-------------------------- Drag and Drop Support ---------------------------*/
#ifdef IC_WIN
virtual bool
 isDragStarting    ( IEvent &event );
#endif


/*------------------------------ Layout Support ------------------------------*/
virtual IMultiLineEdit
 &setLayoutDistorted     ( unsigned long layoutAttributeOn,
                           unsigned long layoutAttributeOff );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMultiLineEdit        ( const IMultiLineEdit& multiLineEdit );
IMultiLineEdit
 &operator=             ( const IMultiLineEdit& multiLineEdit );

/*--------------------------------- Private ----------------------------------*/
long
  exportFile            ( const char* fileName,
                          bool flMarkedAreaOnly );
#ifdef   IC_PM
unsigned long
  exportToBuffer        ( long*         insertion_point,
                          unsigned long buffer_length,
                          const char*   buffer ),
  importFromBuffer      ( long*         insertion_point,
                          unsigned long buffer_length,
                          const char*   buffer );
#endif   //IC_PM

#ifdef IC_MOTIF
unsigned long
  lineFromPosition      ( unsigned long pos ) const;
unsigned long
  positionFromLine      ( unsigned long linenumber ) const;
enum LinePosDirection   {
  dLineFromPosition,
  dPositionFromLine
};
unsigned long
  lineToFromPosition    ( unsigned long posOrLinenumber,
                          LinePosDirection direction ) const;
unsigned long
  lineLength            ( unsigned long     ipt ) const;
IMultiLineEdit
 &wrapIt                ( const IWindowHandle& handle );
#endif   //IC_MOTIF

unsigned long
  textLengthAfterFormat ( ) const;

static Style
  currentDefaultStyle;

#ifdef IC_WIN
unsigned long
  fcharLimit;
bool
  flimitSet;
#endif

bool
  bRefresh;

IMultiLineEditData
 *fMultiLineEditData;

friend class IMultiLineHandler;
friend class IMultiLineEditData;
/*---------------------------- Obsolete Members ------------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
virtual IMultiLineEdit
 &setChangedFlag    ( bool changed=true ),
 &resetChangedFlag  ( );
bool
  isChanged         ( ) const;
#endif
};

INESTEDBITFLAGCLASSFUNCS(Style, IMultiLineEdit)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
