// Revision: 02 1.5.1.3 source/ui/baseapp/imenuhdr.hpp, menu, ioc.v400, 980918 
#ifndef _IMENUHDR_
#define _IMENUHDR_
/*******************************************************************************
* FILE NAME: imenuhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMenuHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <imenuevt.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISubmenu;

#pragma enum(4)
#pragma pack(push,4)

class IMenuHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuHandler ( );
virtual
 ~IMenuHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  makePopUpMenu ( IMenuEvent& menuEvent ),
  menuShowing   ( IMenuEvent& menuEvent,
                  ISubmenu&   submenuAboutToShow ),
  menuSelected  ( IMenuEvent& menuEvent ),
  menuEnded     ( IMenuEvent& menuEvent );

/*------------------------------ Menu Emphasis -------------------------------*/
virtual void
  addSourceEmphasis    ( const IMenuEvent& menuEvent ),
  removeSourceEmphasis ( const IMenuEvent& menuEvent );

private:
void
  cachePopupIdForEnd   ( const IMenuHandle& menuHandle,
                         unsigned long      itemId ),
  deletePopupCache     ();

void
 *fhMenuSelect,
 *fpPopCacheList;
}; // IMenuHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* IMENUHDR */
