// Revision: 00 1.5.1.3 source/ui/baseapp/imenuevt.hpp, menu, ioc.v400, 980918 
#ifndef _IMENUEVT_
  #define _IMENUEVT_
/******************************************************************************
* FILE NAME: imenuevt.hpp                                                     *
*                                                                             *
* DESCRIPTION:                                                                *
*    Declaration of the class:                                                *
*      IMenuEvent                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPoint;
class IMenuItem;
class IMenuHandler;

#pragma enum(4)
#pragma pack(push,4)

class IMenuEvent  : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuEvent (IEvent& event);
virtual
 ~IMenuEvent ( );

/*---------------------------- Event Information -----------------------------*/
unsigned long
  menuItemId    ( ) const;

IMenuItem
  menuItem      ( ) const;

IPoint
  mousePosition ( ) const;

private:
friend class IMenuHandler;
void
 *fPrevMenuParent;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* IMENUEVT */
