// Revision: 95 1.9.1.5 source/ui/baseapp/imenubar.hpp, menu, ioc.v400, 980918 
#ifndef _IMENUBAR_
#define _IMENUBAR_
/*******************************************************************************
* FILE NAME: imenubar.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMenuBar                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;
class IMenuBarData;
class IResourceId;

#pragma enum(4)
#pragma pack(push,4)

class IMenuBar : public IMenu {
typedef IMenu
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  IMenuBar ( const IResourceId& menuResId,
             IFrameWindow*      owner);

  IMenuBar ( IFrameWindow*      owner,
             const Style&       style = defaultStyle() );

virtual
 ~IMenuBar ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IMenuBar, IMenu);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU empty,
  IC_IMPORTU wrapper;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

/*----------------------------- Replacing Menus ------------------------------*/
virtual IMenuBar
#ifdef IC_WIN
  &setMenu        ( const IMenuHandle& menuHandle ),
#endif
  &setMenu        ( const IResourceId&  menuResId );

private:

#ifdef IC_MOTIF
/*---------------------- Event-Handling Implementation -----------------------*/
virtual void
  registerCallbacks   ( ),
  unregisterCallbacks ( );
#endif //IC_MOTIF

/*------------------------------ Hidden Members ------------------------------*/
  IMenuBar   ( const IMenuBar& menuBar );
IMenuBar
 &operator = ( const IMenuBar& menuBar );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

IMenuBarData
 *fMenuBarData;

}; // IMenuBar

INESTEDBITFLAGCLASSFUNCS(Style, IMenuBar)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <imenubar.inl>

#endif  /* _IMENUBAR_ */
