// Revision: 91 1.8.1.14 source/ui/baseapp/imenu.hpp, menu, ioc.v400, 980918 
#ifndef _IMENU_
#define _IMENU_
/*******************************************************************************
* FILE NAME: imenu.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMenu                                                                    *
*     IMenu::Cursor                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>
#include <iframe.hpp>
#include <istdntfy.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMenuItem;
//class IColor;
class IResourceId;
class IMenuData;
class IMenuCursorData;
struct _WidgetRec;
union _XEvent;

#pragma enum(4)
#pragma pack(push,4)

class IMenu : public IStandardNotifier {
typedef IStandardNotifier
  Inherited;
public:
/*--------------------------- Static Functions -------------------------------*/
static IMenuHandle
  menuWithParent(IWindow& parent);

/*------------------------------- Constructors -------------------------------*/
#ifdef IC_PMWIN
  IMenu ( const IMenuHandle& menuHandle );
#endif

virtual
 ~IMenu ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IMenu);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU visible;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    aStyle );

/*------------------------------- Adding Items -------------------------------*/
virtual IMenu
 &addItem      ( IMenuItem&           menuItem,
                 unsigned long        intoSubmenuId = 0),
 &addText      ( unsigned long        newItemId,
                 const char*          itemText,
                 unsigned long        intoSubmenuId = 0),
 &addText      ( unsigned long        newItemId,
                 const IResourceId&   textResId,
                 unsigned long        intoSubmenuId = 0),
 &addBitmap    ( unsigned long        newItemId,
                 const IBitmapHandle& itemBitmap,
                 unsigned long        intoSubmenuId = 0),
 &addBitmap    ( unsigned long        newItemId,
                 const IResourceId&   bitmapResId,
                 unsigned long        intoSubmenuId = 0),
 &addBitmap    ( unsigned long        newItemId,
                 unsigned long        bitmapResId,
                 unsigned long        intoSubmenuId = 0),
 &addSeparator ( unsigned long        newItemId,
                 unsigned long        intoSubmenuId),
 &addSeparator ( unsigned long        intoSubmenuId = 0 ),
 &addSubmenu   ( unsigned long        itemId ),
 &addSubmenu   ( unsigned long        itemId,
                 const IResourceId&   submenuResId );

/*----------------------------- Replacing Items ------------------------------*/
virtual IMenu
 &setItem    ( const IMenuItem&     menuItem ),
 &setText    ( unsigned long        menuItemId,
               const char*          newText     ),
 &setText    ( unsigned long        menuItemId,
               const IResourceId&   newTextResId ),
 &setBitmap  ( unsigned long        menuItemId,
               const IBitmapHandle& bitmapHandle ),
 &setBitmap  ( unsigned long        menuItemId,
               const IResourceId&   newBitmapResId ),
 &setBitmap  ( unsigned long        menuItemId,
               unsigned long        newBitmapResId ),
 &setSubmenu ( unsigned long        itemId,
               const IResourceId&   submenuResId );

/*------------------------------ Removing Items ------------------------------*/
virtual IMenu
 &deleteItem    ( unsigned long itemId ),
 &removeSubmenu ( unsigned long itemWithSubmenuId );

/*-------------------------------- Selection ---------------------------------*/
virtual IMenu
 &checkItem     ( unsigned long itemId,
                  bool       check  = true ),
 &uncheckItem   ( unsigned long itemId ),
 &enableItem    ( unsigned long itemId,
                  bool       enable = true ),
 &disableItem   ( unsigned long itemId ),
 &selectItem    ( unsigned long itemId );

bool
  isItemChecked ( unsigned long itemId ) const,
  isItemEnabled ( unsigned long itemId ) const;

/*----------------------------- Item Properties ------------------------------*/
IMenuItem
  menuItem      ( unsigned long itemId ) const;
IRectangle
  itemRect      ( unsigned long itemId ) const;
unsigned long
  numberOfItems ( unsigned long forSubmenuId = 0 ) const;

//-------------------------- Menu Control ------------------------------------
//AJ: these will all be reimplemented to work on all platforms
virtual bool
  isValid            ( ) const,         //for back compatibility
  isFrameWindow      ( ) const;         //for back compatibility
virtual IWindow
 *owner              ( ) const;
virtual IMenu
 &enableUpdate       ( bool           enableWindow = true ),
 &disableUpdate      ( ),
 &refresh            ( IWindow::RefreshType       type=IWindow::paintAll ),
 &refresh            ( const IRectangle& invalidRectangle,
                       bool           immediate=false );
virtual unsigned long
  id                 ( ) const;

virtual IMenuHandle
  menuHandle    ( ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual unsigned long
  conditionalCascade       ( unsigned long itemWithSubmenuId);
virtual IMenu
 &setConditionalCascade    ( unsigned long itemWithSubmenuId,
                             unsigned long defaultItemId ),
 &removeConditionalCascade ( unsigned long itemWithSubmenuId );
#endif

/*----------------------------- Menu Item Help -------------------------------*/
virtual IMenu
 &setItemHelpId       ( unsigned long  menuItemId,
                        unsigned long  helpTopicId );
unsigned long
  itemHelpId          ( unsigned long  menuItemId ) const;

class Cursor {
public :
/*---------------------------- Constructors -----------------------------*/
  Cursor ( const IMenu& menu,
           unsigned long forSubmenuId = 0 );

virtual
 ~Cursor ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( );

/*-------------------------- Cursor Validation --------------------------*/
virtual bool
  isValid    ( ) const;
virtual void
  invalidate ( );

private:
/*--------------------------- Hidden Members ----------------------------*/
  Cursor ( const Cursor& cursor );

/*------------------------------- Private -------------------------------*/
friend class IMenu;
friend class IMenuData;

long
  lCurrent;
unsigned long
  ulSubmenu;
IMenu
 *pMenu;

IMenuCursorData
 *fCursorData;
}; // IMenu::Cursor

/*--------------------------- Cursored Operations ----------------------------*/
virtual IMenuItem
  elementAt       ( const Cursor& cursor ) const;

virtual IMenu
 &deleteAt        ( Cursor&       cursor ),
 &removeSubmenuAt ( Cursor&       cursor ),

 &add             ( IMenuItem&    menuItem,
                    Cursor&       cursor ),
 &addAsNext       ( IMenuItem&    menuItem,
                    Cursor&       cursor );

Cursor
  cursor          ( unsigned long itemId,
                    unsigned long inSubmenuId = 0 ) const;

/*-------------------------- Observer Notification ---------------------------*/
//AJ virtual IMenu
//AJ  &enableNotification ( bool enable = true );

//AJ*************** New methods promoted from IWindow *************************
//------------------------ Menu Visibility ----------------------------------

virtual IMenu
 &show               ( bool           showMenu = true ),
 &hide               ( );

bool
  isVisible          ( ) const,
  isShowing          ( ) const;

/*-------------------------- Drag and Drop Support ---------------------------*/
#ifndef IC_WIN
IDMItemProvider
 *itemProvider    ( ) const;

IMenu
 &setItemProvider ( IDMItemProvider* dragProvider );
#endif

/*-------------------------- Non-portable Methods ----------------------------*/
#ifdef IC_MOTIFPM
virtual IWindow
 *window() const;

virtual IWindowHandle
  handle() const;
#endif

//*************** end of new methods promoted from IWindow *****************

protected:
/*------------------------------- Constructors -------------------------------*/
  IMenu ( );

#ifdef IC_MOTIFPM
/*-------------------------- Non-portable Methods ----------------------------*/
void
  setWindow(IWindow* window);
#endif

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMenu      ( const IMenu& menu );
IMenu
 &operator = ( const IMenu& menu );

/*--------------------------------- Private ----------------------------------*/
friend class IMenuBar;
friend class IPopUpMenu;
friend class ISubmenu;
friend class ISystemMenu;
#ifdef IC_MOTIF
friend class IMenuBld;
friend class IAixMenuImp;
friend class IMenuHandler;
friend class IMenuDrawItemHandler;
friend class IMenuData;
friend class IMenu::Cursor;
friend void _System imenuMotifCallback(
                                       _WidgetRec*    handle,
                                       void* client_data,
                                       void* call_data);
friend class ICurrentThreadData;
#endif

unsigned long
  menuItemId     ( const Cursor&        cursor ) const;
void
  refCountBitmap ( const IBitmapHandle& handle );
IMenuHandle
  submenuHandle  ( unsigned long        submenuId ) const;
#ifdef IC_MOTIF
void
  setItemProperties( IMenuItem         &newItem,         //26651
                     unsigned long     intoSubmenuId,
                     IWindowHandle     itemButton );
IMenuItem
  menuItemWithHandle( IWindowHandle itemHandle ) const;   //27045
void
  addItemInternal( IMenuItem           &newItem,
                   unsigned long       intoSubmenuId ); //27605
#endif
#ifdef IC_WIN
IMenuHandle
  fhMenu;
IWindowHandle
  fowner;
IFrameWindow
 *fmenuFrame;
#else
IWindow
 *fWindow;

bool
  fMenuWindowNewdInCtor;
#endif

static Style
  currentDefaultStyle;
void
 *pBitmapList;

IMenuData
 *fMenuData;

}; // IMenu


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <imenu.inl>

#endif  /* _IMENU_ */

