// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 94 1.5.1.4 source/core/collect/imaptab.h, collection, ioc.v400, 980918 
#ifndef _IMAPTAB_
#define _IMAPTAB_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimaptab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMapAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMapAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsTableCursor
                            (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMapAsTable :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsTable <Element, Key, ElementOps> Self;

  typedef  IMapAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGMapAsTable
                            (INumber = 100);

           IGMapAsTable
                            (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsTable <Element, Key, ElementOps>&
           operator=        (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMapAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMapAsTable :
  public IGMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMapAsTable <Element, Key> Self;

#define IMapAsTableTypedef(Element, Key)\
  typedef  IMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMapAsTable
                            (INumber = 100);

















protected:

           IMapAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMapAsTable :
  public IGMapAsTable
          <Element, Key, ElementOps > {

  typedef  IVGMapAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMapAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMapAsTable
                            (INumber = 100);

















protected:

           IVGMapAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMapAsTable :
  public IVGMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMapAsTable <Element, Key> Self;

#define IVMapAsTableTypedef(Element, Key)\
  typedef  IVMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMapAsTable
                            (INumber = 100);

















protected:

           IVMapAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imaptab.inl>


#pragma info (restore)


#endif // _IMAPTAB_
