#ifndef _IMAPSTS2_
  #define _IMAPSTS2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <ikeyset2.h>

  template <class Element, class Key, class Imp>
    class ITImpMapOnSortedLinkedSequence : public ITImpKeySet<Element, Key, Imp>
  {
  public:
    ITImpMapOnSortedLinkedSequence( unsigned long numberOfElements = 100);
    ~ITImpMapOnSortedLinkedSequence();
  };

  template <class Element, class Key>
    class IMapOnSortedLinkedSequence : public ITImpMapOnSortedLinkedSequence<Element, Key, Element>
  {
    public:
    IMapOnSortedLinkedSequence( unsigned long numberOfElements = 100);
   ~IMapOnSortedLinkedSequence();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element, class Key>
      class IVPtrMapOnSortedLinkedSequence : public ITImpMapOnSortedLinkedSequence<Element, Key, void*>
    {
      public:
      IVPtrMapOnSortedLinkedSequence( unsigned long numberOfElements = 100);
     ~IVPtrMapOnSortedLinkedSequence();
    };
  #else
    #define IVPtrMapOnSortedLinkedSequence IMapOnSortedLinkedSequence
  #endif

  #ifndef __TEMPINC__
    #include <imapsts2.c>
  #endif

#else
  #include <imapsts.h>
  #define IVPtrMapOnSortedLinkedSequence IMapOnSortedLinkedSequence
#endif

#endif // _IMAPSTS2_

