#ifndef _IMAPLST2_
  #define _IMAPLST2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <ikeyset2.h>

  template <class Element, class Key, class Imp>
    class ITImpMapAsList : public ITImpKeySet<Element, Key, Imp>
  {
  public:
    ITImpMapAsList( unsigned long numberOfElements = 100);
    ~ITImpMapAsList();
  };

  template <class Element, class Key>
    class IMapAsList : public ITImpMapAsList<Element, Key, Element>
  {
    public:
    IMapAsList( unsigned long numberOfElements = 100);
   ~IMapAsList();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element, class Key>
      class IVPtrMapAsList : public ITImpMapAsList<Element, Key, void*>
    {
      public:
      IVPtrMapAsList( unsigned long numberOfElements = 100);
     ~IVPtrMapAsList();
    };
  #else
    #define IVPtrMapAsList IMapAsList
  #endif

  #ifndef __TEMPINC__
    #include <imaplst2.c>
  #endif

#else
  #include <imaplst.h>
  #define IVPtrMapAsList IMapAsList
#endif

#endif // _IMAPLST2_

