// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 89 1.6.1.4 source/core/collect/imaplst.h, collection, ioc.v400, 980918 
#ifndef _IMAPLST_
#define _IMAPLST_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimaplst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMapAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMapAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsListCursor
                            (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsListCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMapAsList :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsList <Element, Key, ElementOps> Self;

  typedef  IMapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsListTypedef(Element, Key, ElementOps)\
  typedef  IMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGMapAsList
                            (INumber = 100);

           IGMapAsList
                            (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsList <Element, Key, ElementOps>&
           operator=        (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMapAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMapAsList :
  public IGMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMapAsList <Element, Key> Self;

#define IMapAsListTypedef(Element, Key)\
  typedef  IMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMapAsList
                            (INumber = 100);

















protected:

           IMapAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMapAsList :
  public IGMapAsList
          <Element, Key, ElementOps > {

  typedef  IVGMapAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMapAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsListTypedef(Element, Key, ElementOps)\
  typedef  IMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMapAsList
                            (INumber = 100);

















protected:

           IVGMapAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMapAsList :
  public IVGMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMapAsList <Element, Key> Self;

#define IVMapAsListTypedef(Element, Key)\
  typedef  IVMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMapAsList
                            (INumber = 100);

















protected:

           IVMapAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imaplst.inl>


#pragma info (restore)


#endif // _IMAPLST_
