// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 87 1.5.1.4 source/core/collect/imaphsh.h, collection, ioc.v400, 980918 
#ifndef _IMAPHSH_
#define _IMAPHSH_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimaphsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMapAsHshTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMapAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsHshTableCursor
                            (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsHshTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMapAsHshTable :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsHshTable <Element, Key, ElementOps> Self;

  typedef  IMapAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapAsHshTableCursor
            <Element, Key, ElementOps> Cursor;




           IGMapAsHshTable
                            (INumber = 100);

           IGMapAsHshTable
                            (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsHshTable <Element, Key, ElementOps>&
           operator=        (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMapAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsHshTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMapAsHshTable :
  public IGMapAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IGMapAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMapAsHshTable <Element, Key> Self;

#define IMapAsHshTableTypedef(Element, Key)\
  typedef  IMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMapAsHshTable
                            (INumber = 100);

















protected:

           IMapAsHshTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMapAsHshTable :
  public IGMapAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGMapAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMapAsHshTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMapAsHshTable
                            (INumber = 100);

















protected:

           IVGMapAsHshTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMapAsHshTable :
  public IVGMapAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IVGMapAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMapAsHshTable <Element, Key> Self;

#define IVMapAsHshTableTypedef(Element, Key)\
  typedef  IVMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMapAsHshTable
                            (INumber = 100);

















protected:

           IVMapAsHshTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imaphsh.inl>


#pragma info (restore)


#endif // _IMAPHSH_
