// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 84 1.5.1.4 source/core/collect/imapdil.h, collection, ioc.v400, 980918 
#ifndef _IMAPDIL_
#define _IMAPDIL_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimapdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMapAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMapAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsDilTableCursor
                            (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMapAsDilTable :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsDilTable <Element, Key, ElementOps> Self;

  typedef  IMapAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGMapAsDilTable
                            (INumber = 100);

           IGMapAsDilTable
                            (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsDilTable <Element, Key, ElementOps>&
           operator=        (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMapAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMapAsDilTable :
  public IGMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMapAsDilTable <Element, Key> Self;

#define IMapAsDilTableTypedef(Element, Key)\
  typedef  IMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMapAsDilTable
                            (INumber = 100);

















protected:

           IMapAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMapAsDilTable :
  public IGMapAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGMapAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMapAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMapAsDilTable
                            (INumber = 100);

















protected:

           IVGMapAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMapAsDilTable :
  public IVGMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMapAsDilTable <Element, Key> Self;

#define IVMapAsDilTableTypedef(Element, Key)\
  typedef  IVMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMapAsDilTable
                            (INumber = 100);

















protected:

           IVMapAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imapdil.inl>


#pragma info (restore)


#endif // _IMAPDIL_
