// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 82 1.5.1.4 source/core/collect/imapbst.h, collection, ioc.v400, 980918 
#ifndef _IMAPBST_
#define _IMAPBST_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimapbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMapAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMapAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsBstTreeCursor
                            (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMapAsBstTree :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsBstTree <Element, Key, ElementOps> Self;

  typedef  IMapAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGMapAsBstTree
                            (INumber = 100);

           IGMapAsBstTree
                            (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsBstTree <Element, Key, ElementOps>&
           operator=        (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMapAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsBstTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMapAsBstTree :
  public IGMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMapAsBstTree <Element, Key> Self;

#define IMapAsBstTreeTypedef(Element, Key)\
  typedef  IMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMapAsBstTree
                            (INumber = 100);

















protected:

           IMapAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMapAsBstTree :
  public IGMapAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGMapAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMapAsBstTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMapAsBstTree
                            (INumber = 100);

















protected:

           IVGMapAsBstTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMapAsBstTree :
  public IVGMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMapAsBstTree <Element, Key> Self;

#define IVMapAsBstTreeTypedef(Element, Key)\
  typedef  IVMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMapAsBstTree
                            (INumber = 100);

















protected:

           IVMapAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imapbst.inl>


#pragma info (restore)


#endif // _IMAPBST_
