// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 80 1.5.1.4 source/core/collect/imapavl.h, collection, ioc.v400, 980918 
#ifndef _IMAPAVL_
#define _IMAPAVL_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimapavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMapAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMapAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsAvlTreeCursor
                            (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMapAsAvlTree :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsAvlTree <Element, Key, ElementOps> Self;

  typedef  IMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGMapAsAvlTree
                            (INumber = 100);

           IGMapAsAvlTree
                            (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMapAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsAvlTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMapAsAvlTree :
  public IGMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMapAsAvlTree <Element, Key> Self;

#define IMapAsAvlTreeTypedef(Element, Key)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMapAsAvlTree
                            (INumber = 100);

















protected:

           IMapAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMapAsAvlTree :
  public IGMapAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGMapAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMapAsAvlTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMapAsAvlTree
                            (INumber = 100);

















protected:

           IVGMapAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMapAsAvlTree :
  public IVGMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMapAsAvlTree <Element, Key> Self;

#define IVMapAsAvlTreeTypedef(Element, Key)\
  typedef  IVMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMapAsAvlTree
                            (INumber = 100);

















protected:

           IVMapAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imapavl.inl>


#pragma info (restore)


#endif // _IMAPAVL_
