// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 78 1.5.1.4 source/core/collect/imap.h, collection, ioc.v400, 980918 
#ifndef _IMAP_
#define _IMAP_

#include <ilanglvl.hpp>
#include <iamap.h>
#include <iicmap.h>

#include <iivmap.h>

#include <iimapavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGMap;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGMapCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGMap
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapCursor
                            (IGMap
                              <
                               Element, Key, ElementOps> const&);

  IGMapCursor <Element, Key, ElementOps>&
           operator=        (IGMapCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGMap :
  public IAMap <Element, Key> {
protected:

  typedef  IGMap <Element, Key, ElementOps> Self;

  typedef  IMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGMapCursor
            <Element, Key, ElementOps> Cursor;




           IGMap
                            (INumber = 100);

           IGMap
                            (IGMap
                              <
                               Element, Key, ElementOps> const&);

  IGMap <Element, Key, ElementOps>&
           operator=        (IGMap
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGMap
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMap
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IMap :
  public IGMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMap <Element, Key> Self;

#define IMapTypedef(Element, Key)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IMap
                            (INumber = 100);

















protected:

           IMap
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGMap :
  public IGMap
          <Element, Key, ElementOps > {

  typedef  IVGMap
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMap
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGMap
                            (INumber = 100);

















protected:

           IVGMap
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVMap :
  public IVGMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMap <Element, Key> Self;

#define IVMapTypedef(Element, Key)\
  typedef  IVMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVMap
                            (INumber = 100);

















protected:

           IVMap
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imap.inl>


#pragma info (restore)


#endif // _IMAP_
