// Revision: 87 1.3.1.3 source/ui/baseapp/ilbdihdr.hpp, listctls, ioc.v400, 980918 
#ifndef _ILBDIHDR_
#define _ILBDIHDR_
/*******************************************************************************
* FILE NAME: ilbdihdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IListBoxDrawItemHandler                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ibitflag.hpp>
#include <ilbdievt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IListBox;
class ISize;
class IWindow;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IListBoxDrawItemHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IListBoxDrawItemHandler ( );

virtual
 ~IListBoxDrawItemHandler ( );

/*---------------------------- Window Attachment -----------------------------*/
virtual IListBoxDrawItemHandler
 &handleEventsFor ( IListBox* listBox ),
 &handleEventsFor ( IWindow*  listBoxOwner );

protected:
/*------------------------------ Event Handling ------------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent&                event );

virtual bool
  setItemSize          ( IListBoxSizeItemEvent& event );

virtual bool
  drawItem             ( IListBoxDrawItemEvent& event ),
  selectItem           ( IListBoxDrawItemEvent& event ),
  deselectItem         ( IListBoxDrawItemEvent& event );

}; // IListBoxDrawItemHandler

#endif /* IC_PMWIN */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ILBDIHDR_ */
