// Revision: 85 1.4.1.3 source/ui/baseapp/ilbdievt.hpp, listctls, ioc.v400, 980918 
#ifndef _ILBDIEVT_
#define _ILBDIEVT_
/*******************************************************************************
* FILE NAME: ilbdievt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IListBoxDrawItemEvent                                                    *
*     IListBoxSizeItemEvent                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <idievt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IListBoxDrawItemHandler;
class ISize;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IListBoxDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IListBoxDrawItemEvent ( IEvent& event );

virtual
 ~IListBoxDrawItemEvent ( );

/*--------------------------------- Testing ----------------------------------*/
bool
  isSelected ( ) const;

/*----------------------------- Selection State ------------------------------*/
IListBoxDrawItemEvent
 &setSelectionStateDrawn ( bool drawn = true );
bool
  isSelectionStateDrawn  ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IListBoxDrawItemHandler;

bool
  isDrawItem        ( ) const,
  isSetHighlight    ( ) const,
  isRemoveHighlight ( ) const;

bool
  fSelectionStateDrawn;
};  // IListBoxDrawItemEvent


class IListBoxSizeItemEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IListBoxSizeItemEvent ( IEvent& event );

virtual
 ~IListBoxSizeItemEvent ( );

/*--------------------------- Item Identification ----------------------------*/
unsigned long
  itemIndex ( ) const;

/*------------------------------- Item Sizing --------------------------------*/
IListBoxSizeItemEvent
 &setItemSize ( const ISize& itemSize );
ISize
  itemSize    ( ) const;

private:
/*----------------------------- Hidden Functions -----------------------------*/
IEvent
 &setResult  ( const IEventResult& eventResult );
};  // IListBoxSizeItemEvent

#endif /* IC_PMWIN */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ILBDIEVT_ */
