// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 06 1.8.1.2 source/core/base/ilanglvl.hpp, oss, portapak  
#ifndef _ILANGLVL_
#define _ILANGLVL_

#ifndef IC_LANG_BOOL

#define IC_LANG_BOOL	0

#endif // IC_LANG_BOOL

#if __IBMCPP__ >= 400

  #ifdef __BOOL__

    #error Error: Use of IBM Open Class Library requires the following options: lang(nokeyword, "bool"), lang(nokeyword, "true"), and lang(nokeyword, "false").

  #endif // __BOOL__

#endif // __IBMCPP__ >= 400

#if __IBMCPP__ >= 400

#define TYPENAME typename

#else

#define TYPENAME

#endif

#if defined(__MWERKS__)

#define IC_RTTI_ENABLED 1
#define IC_EXTENDED_RTTI_ENABLED 0

#elif defined(_MSC_VER)

#define IC_RTTI_ENABLED 1
#define IC_EXTENDED_RTTI_ENABLED 0

#elif defined(__IBMCPP__)

#if __IBMCPP__ >= 400

  #ifndef __RTTI_DYNAMIC_CAST__

    #error Error: Use of IBM Open Class Library requires the "gen(rtti, yes)" option.

  #endif // __RTTI_DYNAMIC_CAST__

#endif // __IBMCPP__ >= 400



  #define IC_RTTI_ENABLED 1
  #define IC_EXTENDED_RTTI_ENABLED 1



































#elif defined(_AIX)

#define IC_RTTI_ENABLED 0
#define IC_EXTENDED_RTTI_ENABLED 0

#else

#error "create support code for your platform in ilanglvl.hpp"

#endif

#if !IC_LANG_BOOL

typedef int bool;

#pragma enum(4)

enum BooleanConstants {
  false = 0,
  true  = 1
};

#pragma enum(pop)

#endif // IC_LANG_BOOL

#if IC_RTTI_ENABLED

#if defined(_AIX) && defined(Bool)
#error You must include ilanglvl.hpp before any X11 headers
#endif

#include <typeinfo.h>

#endif // IC_RTTI_ENABLED

#endif // _ILANGLVL_
