// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 75 1.5.1.4 source/core/collect/ikstab.h, collection, ioc.v400, 980918 
#ifndef _IKSTAB_
#define _IKSTAB_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iikstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySetAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySetAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsTableCursor
                            (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySetAsTable :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySetAsTable
                            (INumber = 100);

           IGKeySetAsTable
                            (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsTable <Element, Key, ElementOps>&
           operator=        (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySetAsTable :
  public IGKeySetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySetAsTable <Element, Key> Self;

#define IKeySetAsTableTypedef(Element, Key)\
  typedef  IKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySetAsTable
                            (INumber = 100);

















protected:

           IKeySetAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySetAsTable :
  public IGKeySetAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySetAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySetAsTable
                            (INumber = 100);

















protected:

           IVGKeySetAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySetAsTable :
  public IVGKeySetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySetAsTable <Element, Key> Self;

#define IVKeySetAsTableTypedef(Element, Key)\
  typedef  IVKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySetAsTable
                            (INumber = 100);

















protected:

           IVKeySetAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikstab.inl>


#pragma info (restore)


#endif // _IKSTAB_
