#ifndef _IKSSTAB2_
  #define _IKSSTAB2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <ikeyset2.h>

  template <class Element, class Key, class Imp>
    class ITImpKeySortedSetAsTable : public ITImpKeySet<Element, Key, Imp>
  {
  public:
    ITImpKeySortedSetAsTable( unsigned long numberOfElements = 100);
    ~ITImpKeySortedSetAsTable();
  };

  template <class Element, class Key>
    class IKeySortedSetAsTable : public ITImpKeySortedSetAsTable<Element, Key, Element>
  {
    public:
    IKeySortedSetAsTable( unsigned long numberOfElements = 100);
   ~IKeySortedSetAsTable();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element, class Key>
      class IVPtrKeySortedSetAsTable : public ITImpKeySortedSetAsTable<Element, Key, void*>
    {
      public:
      IVPtrKeySortedSetAsTable( unsigned long numberOfElements = 100);
     ~IVPtrKeySortedSetAsTable();
    };
  #else
    #define IVPtrKeySortedSetAsTable IKeySortedSetAsTable
  #endif

  #ifndef __TEMPINC__
    #include <iksstab2.c>
  #endif

#else
  #include <iksstab.h>
  #define IVPtrKeySortedSetAsTable IKeySortedSetAsTable
#endif

#endif // _IKSSTAB2_

