// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 72 1.5.1.4 source/core/collect/iksstab.h, collection, ioc.v400, 980918 
#ifndef _IKSSTAB_
#define _IKSSTAB_

#include <ilanglvl.hpp>
#include <iakss.h>
#include <iickss.h>

#include <iivkss.h>

#include <iiksstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedSetAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsTableCursor
                            (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsTable :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedSetAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedSetAsTable
                            (INumber = 100);

           IGKeySortedSetAsTable
                            (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedSetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedSetAsTable :
  public IGKeySortedSetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedSetAsTable <Element, Key> Self;

#define IKeySortedSetAsTableTypedef(Element, Key)\
  typedef  IKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedSetAsTable
                            (INumber = 100);

















protected:

           IKeySortedSetAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsTable :
  public IGKeySortedSetAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedSetAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedSetAsTable
                            (INumber = 100);

















protected:

           IVGKeySortedSetAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedSetAsTable :
  public IVGKeySortedSetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedSetAsTable <Element, Key> Self;

#define IVKeySortedSetAsTableTypedef(Element, Key)\
  typedef  IVKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedSetAsTable
                            (INumber = 100);

















protected:

           IVKeySortedSetAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksstab.inl>


#pragma info (restore)


#endif // _IKSSTAB_
