#ifndef _IKSSSTS2_
  #define _IKSSSTS2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <ikeyset2.h>

  template <class Element, class Key, class Imp>
    class ITImpKeySortedSetOnSortedTabularSequence : public ITImpKeySet<Element, Key, Imp>
  {
  public:
    ITImpKeySortedSetOnSortedTabularSequence( unsigned long numberOfElements = 100);
    ~ITImpKeySortedSetOnSortedTabularSequence();
  };

  template <class Element, class Key>
    class IKeySortedSetOnSortedTabularSequence : public ITImpKeySortedSetOnSortedTabularSequence<Element, Key, Element>
  {
    public:
    IKeySortedSetOnSortedTabularSequence( unsigned long numberOfElements = 100);
   ~IKeySortedSetOnSortedTabularSequence();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element, class Key>
      class IVPtrKeySortedSetOnSortedTabularSequence : public ITImpKeySortedSetOnSortedTabularSequence<Element, Key, void*>
    {
      public:
      IVPtrKeySortedSetOnSortedTabularSequence( unsigned long numberOfElements = 100);
     ~IVPtrKeySortedSetOnSortedTabularSequence();
    };
  #else
    #define IVPtrKeySortedSetOnSortedTabularSequence IKeySortedSetOnSortedTabularSequence
  #endif

  #ifndef __TEMPINC__
    #include <iksssts2.c>
  #endif

#else
  #include <iksssts.h>
  #define IVPtrKeySortedSetOnSortedTabularSequence IKeySortedSetOnSortedTabularSequence
#endif

#endif // _IKSSSTS2_

