// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 67 1.5.1.4 source/core/collect/iksslst.h, collection, ioc.v400, 980918 
#ifndef _IKSSLST_
#define _IKSSLST_

#include <ilanglvl.hpp>
#include <iakss.h>
#include <iickss.h>

#include <iivkss.h>

#include <iiksslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedSetAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsListCursor
                            (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsList :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsList <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedSetAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedSetAsList
                            (INumber = 100);

           IGKeySortedSetAsList
                            (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsList <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedSetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedSetAsList :
  public IGKeySortedSetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedSetAsList <Element, Key> Self;

#define IKeySortedSetAsListTypedef(Element, Key)\
  typedef  IKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedSetAsList
                            (INumber = 100);

















protected:

           IKeySortedSetAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsList :
  public IGKeySortedSetAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedSetAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedSetAsList
                            (INumber = 100);

















protected:

           IVGKeySortedSetAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedSetAsList :
  public IVGKeySortedSetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedSetAsList <Element, Key> Self;

#define IVKeySortedSetAsListTypedef(Element, Key)\
  typedef  IVKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedSetAsList
                            (INumber = 100);

















protected:

           IVKeySortedSetAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksslst.inl>


#pragma info (restore)


#endif // _IKSSLST_
