#ifndef _IKSSET2_
  #define _IKSSET2_
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>

#ifdef IC_USE_STL
  #include <ikeyset2.h>

  template <class Element, class Key, class Imp>
    class ITImpKeySortedSet : public ITImpKeySet<Element, Key, Imp>
  {
  public:
    ITImpKeySortedSet( unsigned long numberOfElements = 100);
    ~ITImpKeySortedSet();
  };

  template <class Element, class Key>
    class IKeySortedSet : public ITImpKeySortedSet<Element, Key, Element>
  {
    public:
    IKeySortedSet( unsigned long numberOfElements = 100);
   ~IKeySortedSet();
  };


  #ifdef IC_USE_STL_VPTR
    template <class Element, class Key>
    class IVPtrKeySortedSet : public ITImpKeySortedSet<Element, Key, void*>
    {
      public:
      IVPtrKeySortedSet( unsigned long numberOfElements = 100);
     ~IVPtrKeySortedSet();
    };
  #else
    #define IVPtrKeySortedSet IKeySortedSet
  #endif

  #ifndef __TEMPINC__
    #include <iksset2.c>
  #endif

#else
  #include <iksset.h>
  #define IVPtrKeySortedSet IKeySortedSet
#endif

#endif // _IKSSET2_

