// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 62 1.5.1.4 source/core/collect/ikssdil.h, collection, ioc.v400, 980918 
#ifndef _IKSSDIL_
#define _IKSSDIL_

#include <ilanglvl.hpp>
#include <iakss.h>
#include <iickss.h>

#include <iivkss.h>

#include <iikssdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedSetAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsDilTableCursor
                            (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsDilTable :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedSetAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedSetAsDilTable
                            (INumber = 100);

           IGKeySortedSetAsDilTable
                            (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedSetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedSetAsDilTable :
  public IGKeySortedSetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedSetAsDilTable <Element, Key> Self;

#define IKeySortedSetAsDilTableTypedef(Element, Key)\
  typedef  IKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedSetAsDilTable
                            (INumber = 100);

















protected:

           IKeySortedSetAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsDilTable :
  public IGKeySortedSetAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedSetAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedSetAsDilTable
                            (INumber = 100);

















protected:

           IVGKeySortedSetAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedSetAsDilTable :
  public IVGKeySortedSetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedSetAsDilTable <Element, Key> Self;

#define IVKeySortedSetAsDilTableTypedef(Element, Key)\
  typedef  IVKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedSetAsDilTable
                            (INumber = 100);

















protected:

           IVKeySortedSetAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikssdil.inl>


#pragma info (restore)


#endif // _IKSSDIL_
