// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 60 1.5.1.4 source/core/collect/ikssbst.h, collection, ioc.v400, 980918 
#ifndef _IKSSBST_
#define _IKSSBST_

#include <ilanglvl.hpp>
#include <iakss.h>
#include <iickss.h>

#include <iivkss.h>

#include <iikssbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedSetAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsBstTreeCursor
                            (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsBstTree :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsBstTree <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedSetAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedSetAsBstTree
                            (INumber = 100);

           IGKeySortedSetAsBstTree
                            (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsBstTree <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedSetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedSetAsBstTree :
  public IGKeySortedSetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedSetAsBstTree <Element, Key> Self;

#define IKeySortedSetAsBstTreeTypedef(Element, Key)\
  typedef  IKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedSetAsBstTree
                            (INumber = 100);

















protected:

           IKeySortedSetAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsBstTree :
  public IGKeySortedSetAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedSetAsBstTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedSetAsBstTree
                            (INumber = 100);

















protected:

           IVGKeySortedSetAsBstTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedSetAsBstTree :
  public IVGKeySortedSetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedSetAsBstTree <Element, Key> Self;

#define IVKeySortedSetAsBstTreeTypedef(Element, Key)\
  typedef  IVKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedSetAsBstTree
                            (INumber = 100);

















protected:

           IVKeySortedSetAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikssbst.inl>


#pragma info (restore)


#endif // _IKSSBST_
