// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 58 1.5.1.4 source/core/collect/ikssavl.h, collection, ioc.v400, 980918 
#ifndef _IKSSAVL_
#define _IKSSAVL_

#include <ilanglvl.hpp>
#include <iakss.h>
#include <iickss.h>

#include <iivkss.h>

#include <iikssavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedSetAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsAvlTreeCursor
                            (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsAvlTree :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsAvlTree <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedSetAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedSetAsAvlTree
                            (INumber = 100);

           IGKeySortedSetAsAvlTree
                            (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedSetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedSetAsAvlTree :
  public IGKeySortedSetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedSetAsAvlTree <Element, Key> Self;

#define IKeySortedSetAsAvlTreeTypedef(Element, Key)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedSetAsAvlTree
                            (INumber = 100);

















protected:

           IKeySortedSetAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsAvlTree :
  public IGKeySortedSetAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedSetAsAvlTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedSetAsAvlTree
                            (INumber = 100);

















protected:

           IVGKeySortedSetAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedSetAsAvlTree :
  public IVGKeySortedSetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedSetAsAvlTree <Element, Key> Self;

#define IVKeySortedSetAsAvlTreeTypedef(Element, Key)\
  typedef  IVKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedSetAsAvlTree
                            (INumber = 100);

















protected:

           IVKeySortedSetAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikssavl.inl>


#pragma info (restore)


#endif // _IKSSAVL_
