// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 56 1.5.1.4 source/core/collect/ikss.h, collection, ioc.v400, 980918 
#ifndef _IKSS_
#define _IKSS_

#include <ilanglvl.hpp>
#include <iakss.h>
#include <iickss.h>

#include <iivkss.h>

#include <iikssavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedSet;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedSet
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetCursor
                            (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedSet :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSet <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedSetCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedSet
                            (INumber = 100);

           IGKeySortedSet
                            (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSet <Element, Key, ElementOps>&
           operator=        (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedSet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedSet :
  public IGKeySortedSet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedSet <Element, Key> Self;

#define IKeySortedSetTypedef(Element, Key)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedSet
                            (INumber = 100);

















protected:

           IKeySortedSet
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedSet :
  public IGKeySortedSet
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSet
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedSet
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedSet
                            (INumber = 100);

















protected:

           IVGKeySortedSet
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedSet :
  public IVGKeySortedSet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedSet <Element, Key> Self;

#define IVKeySortedSetTypedef(Element, Key)\
  typedef  IVKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedSet
                            (INumber = 100);

















protected:

           IVKeySortedSet
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikss.inl>


#pragma info (restore)


#endif // _IKSS_
