// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 54 1.5.1.4 source/core/collect/ikslst.h, collection, ioc.v400, 980918 
#ifndef _IKSLST_
#define _IKSLST_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iikslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySetAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySetAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsListCursor
                            (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySetAsList :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsList <Element, Key, ElementOps> Self;

  typedef  IKeySetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySetAsList
                            (INumber = 100);

           IGKeySetAsList
                            (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsList <Element, Key, ElementOps>&
           operator=        (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySetAsList :
  public IGKeySetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySetAsList <Element, Key> Self;

#define IKeySetAsListTypedef(Element, Key)\
  typedef  IKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySetAsList
                            (INumber = 100);

















protected:

           IKeySetAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySetAsList :
  public IGKeySetAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySetAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySetAsList
                            (INumber = 100);

















protected:

           IVGKeySetAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySetAsList :
  public IVGKeySetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySetAsList <Element, Key> Self;

#define IVKeySetAsListTypedef(Element, Key)\
  typedef  IVKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySetAsList
                            (INumber = 100);

















protected:

           IVKeySetAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikslst.inl>


#pragma info (restore)


#endif // _IKSLST_
