// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 52 1.6.1.4 source/core/collect/ikshsh.h, collection, ioc.v400, 980918 
#ifndef _IKSHSH_
#define _IKSHSH_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iikshsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySetAsHshTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySetAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsHshTableCursor
                            (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsHshTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySetAsHshTable :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsHshTable <Element, Key, ElementOps> Self;

  typedef  IKeySetAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetAsHshTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySetAsHshTable
                            (INumber = 100);

           IGKeySetAsHshTable
                            (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsHshTable <Element, Key, ElementOps>&
           operator=        (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySetAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsHshTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySetAsHshTable :
  public IGKeySetAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IGKeySetAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySetAsHshTable <Element, Key> Self;

#define IKeySetAsHshTableTypedef(Element, Key)\
  typedef  IKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySetAsHshTable
                            (INumber = 100);

















protected:

           IKeySetAsHshTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySetAsHshTable :
  public IGKeySetAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySetAsHshTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySetAsHshTable
                            (INumber = 100);

















protected:

           IVGKeySetAsHshTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySetAsHshTable :
  public IVGKeySetAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IVGKeySetAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySetAsHshTable <Element, Key> Self;

#define IVKeySetAsHshTableTypedef(Element, Key)\
  typedef  IVKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySetAsHshTable
                            (INumber = 100);

















protected:

           IVKeySetAsHshTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikshsh.inl>


#pragma info (restore)


#endif // _IKSHSH_
