// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 50 1.5.1.4 source/core/collect/iksdil.h, collection, ioc.v400, 980918 
#ifndef _IKSDIL_
#define _IKSDIL_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iiksdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySetAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySetAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsDilTableCursor
                            (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySetAsDilTable :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySetAsDilTable
                            (INumber = 100);

           IGKeySetAsDilTable
                            (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySetAsDilTable :
  public IGKeySetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySetAsDilTable <Element, Key> Self;

#define IKeySetAsDilTableTypedef(Element, Key)\
  typedef  IKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySetAsDilTable
                            (INumber = 100);

















protected:

           IKeySetAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySetAsDilTable :
  public IGKeySetAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySetAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySetAsDilTable
                            (INumber = 100);

















protected:

           IVGKeySetAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySetAsDilTable :
  public IVGKeySetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySetAsDilTable <Element, Key> Self;

#define IVKeySetAsDilTableTypedef(Element, Key)\
  typedef  IVKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySetAsDilTable
                            (INumber = 100);

















protected:

           IVKeySetAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksdil.inl>


#pragma info (restore)


#endif // _IKSDIL_
