// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 48 1.5.1.4 source/core/collect/iksbtab.h, collection, ioc.v400, 980918 
#ifndef _IKSBTAB_
#define _IKSBTAB_

#include <ilanglvl.hpp>
#include <iaksb.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedBagAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagAsTableCursor
                            (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsTable :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBagAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedBagAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedBagAsTable
                            (INumber = 100);

           IGKeySortedBagAsTable
                            (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedBagAsTable :
  public IGKeySortedBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedBagAsTable <Element, Key> Self;

#define IKeySortedBagAsTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedBagAsTable
                            (INumber = 100);

















protected:

           IKeySortedBagAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedBagAsTable :
  public IGKeySortedBagAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBagAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedBagAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedBagAsTable
                            (INumber = 100);

















protected:

           IVGKeySortedBagAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedBagAsTable :
  public IVGKeySortedBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedBagAsTable <Element, Key> Self;

#define IVKeySortedBagAsTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedBagAsTable
                            (INumber = 100);

















protected:

           IVKeySortedBagAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksbtab.inl>


#pragma info (restore)


#endif // _IKSBTAB_
