// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 45 1.5.1.4 source/core/collect/iksbst.h, collection, ioc.v400, 980918 
#ifndef _IKSBST_
#define _IKSBST_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iiksbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySetAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySetAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsBstTreeCursor
                            (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySetAsBstTree :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsBstTree <Element, Key, ElementOps> Self;

  typedef  IKeySetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySetAsBstTree
                            (INumber = 100);

           IGKeySetAsBstTree
                            (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsBstTree <Element, Key, ElementOps>&
           operator=        (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsBstTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySetAsBstTree :
  public IGKeySetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySetAsBstTree <Element, Key> Self;

#define IKeySetAsBstTreeTypedef(Element, Key)\
  typedef  IKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySetAsBstTree
                            (INumber = 100);

















protected:

           IKeySetAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySetAsBstTree :
  public IGKeySetAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySetAsBstTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySetAsBstTree
                            (INumber = 100);

















protected:

           IVGKeySetAsBstTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySetAsBstTree :
  public IVGKeySetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySetAsBstTree <Element, Key> Self;

#define IVKeySetAsBstTreeTypedef(Element, Key)\
  typedef  IVKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySetAsBstTree
                            (INumber = 100);

















protected:

           IVKeySetAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksbst.inl>


#pragma info (restore)


#endif // _IKSBST_
