// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 42 1.5.1.4 source/core/collect/iksblst.h, collection, ioc.v400, 980918 
#ifndef _IKSBLST_
#define _IKSBLST_

#include <ilanglvl.hpp>
#include <iaksb.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedBagAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagAsListCursor
                            (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsList :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBagAsList <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedBagAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedBagAsList
                            (INumber = 100);

           IGKeySortedBagAsList
                            (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsList <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedBagAsList :
  public IGKeySortedBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedBagAsList <Element, Key> Self;

#define IKeySortedBagAsListTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedBagAsList
                            (INumber = 100);

















protected:

           IKeySortedBagAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedBagAsList :
  public IGKeySortedBagAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBagAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedBagAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedBagAsList
                            (INumber = 100);

















protected:

           IVGKeySortedBagAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedBagAsList :
  public IVGKeySortedBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedBagAsList <Element, Key> Self;

#define IVKeySortedBagAsListTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedBagAsList
                            (INumber = 100);

















protected:

           IVKeySortedBagAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksblst.inl>


#pragma info (restore)


#endif // _IKSBLST_
