// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 40 1.5.1.4 source/core/collect/iksbdil.h, collection, ioc.v400, 980918 
#ifndef _IKSBDIL_
#define _IKSBDIL_

#include <ilanglvl.hpp>
#include <iaksb.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksbdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedBagAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagAsDilTableCursor
                            (IGKeySortedBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsDilTable :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBagAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedBagAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedBagAsDilTable
                            (INumber = 100);

           IGKeySortedBagAsDilTable
                            (IGKeySortedBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedBagAsDilTable :
  public IGKeySortedBagAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBagAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedBagAsDilTable <Element, Key> Self;

#define IKeySortedBagAsDilTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedBagAsDilTable
                            (INumber = 100);

















protected:

           IKeySortedBagAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedBagAsDilTable :
  public IGKeySortedBagAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBagAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedBagAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedBagAsDilTable
                            (INumber = 100);

















protected:

           IVGKeySortedBagAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedBagAsDilTable :
  public IVGKeySortedBagAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBagAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedBagAsDilTable <Element, Key> Self;

#define IVKeySortedBagAsDilTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedBagAsDilTable
                            (INumber = 100);

















protected:

           IVKeySortedBagAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksbdil.inl>


#pragma info (restore)


#endif // _IKSBDIL_
