// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 37 1.5.1.4 source/core/collect/iksb.h, collection, ioc.v400, 980918 
#ifndef _IKSB_
#define _IKSB_

#include <ilanglvl.hpp>
#include <iaksb.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySortedBag;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySortedBagCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGKeySortedBag
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagCursor
                            (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySortedBag :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBag <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySortedBagCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySortedBag
                            (INumber = 100);

           IGKeySortedBag
                            (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBag <Element, Key, ElementOps>&
           operator=        (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySortedBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySortedBag :
  public IGKeySortedBag
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBag
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySortedBag <Element, Key> Self;

#define IKeySortedBagTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySortedBag
                            (INumber = 100);

















protected:

           IKeySortedBag
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySortedBag :
  public IGKeySortedBag
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBag
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySortedBag
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySortedBag
                            (INumber = 100);

















protected:

           IVGKeySortedBag
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySortedBag :
  public IVGKeySortedBag
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBag
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySortedBag <Element, Key> Self;

#define IVKeySortedBagTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySortedBag
                            (INumber = 100);

















protected:

           IVKeySortedBag
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksb.inl>


#pragma info (restore)


#endif // _IKSB_
