// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 35 1.5.1.4 source/core/collect/iksavl.h, collection, ioc.v400, 980918 
#ifndef _IKSAVL_
#define _IKSAVL_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iiksavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySetAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySetAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsAvlTreeCursor
                            (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySetAsAvlTree :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsAvlTree <Element, Key, ElementOps> Self;

  typedef  IKeySetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySetAsAvlTree
                            (INumber = 100);

           IGKeySetAsAvlTree
                            (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySetAsAvlTree :
  public IGKeySetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySetAsAvlTree <Element, Key> Self;

#define IKeySetAsAvlTreeTypedef(Element, Key)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySetAsAvlTree
                            (INumber = 100);

















protected:

           IKeySetAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySetAsAvlTree :
  public IGKeySetAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySetAsAvlTree
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySetAsAvlTree
                            (INumber = 100);

















protected:

           IVGKeySetAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySetAsAvlTree :
  public IVGKeySetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySetAsAvlTree <Element, Key> Self;

#define IVKeySetAsAvlTreeTypedef(Element, Key)\
  typedef  IVKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySetAsAvlTree
                            (INumber = 100);

















protected:

           IVKeySetAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iksavl.inl>


#pragma info (restore)


#endif // _IKSAVL_
