// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 33 1.6.1.4 source/core/collect/iks.h, collection, ioc.v400, 980918 
#ifndef _IKS_
#define _IKS_

#include <ilanglvl.hpp>
#include <iaks.h>
#include <iicks.h>

#include <iivks.h>

#include <iiksavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeySet;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeySetCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeySet
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetCursor
                            (IGKeySet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeySet :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySet <Element, Key, ElementOps> Self;

  typedef  IKeySetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeySetCursor
            <Element, Key, ElementOps> Cursor;




           IGKeySet
                            (INumber = 100);

           IGKeySet
                            (IGKeySet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySet <Element, Key, ElementOps>&
           operator=        (IGKeySet
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeySet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySet
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeySet :
  public IGKeySet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeySet <Element, Key> Self;

#define IKeySetTypedef(Element, Key)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeySet
                            (INumber = 100);

















protected:

           IKeySet
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeySet :
  public IGKeySet
          <Element, Key, ElementOps > {

  typedef  IVGKeySet
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeySet
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeySet
                            (INumber = 100);

















protected:

           IVGKeySet
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeySet :
  public IVGKeySet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeySet <Element, Key> Self;

#define IVKeySetTypedef(Element, Key)\
  typedef  IVKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeySet
                            (INumber = 100);

















protected:

           IVKeySet
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iks.inl>


#pragma info (restore)


#endif // _IKS_
