// Revision: 83 1.6.1.3 source/ui/baseapp/ikeyhdr.hpp, userinput, ioc.v400, 980918  
#ifndef _IKEYHDR_
  #define _IKEYHDR_
/*******************************************************************************
* FILE NAME: ikeyhdr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IKeyboardHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ikeyevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IKeyboardHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------ Constructors --------------------------------*/
  IKeyboardHandler     ( );
virtual
 ~IKeyboardHandler     ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  scanCodeKeyPress     ( IKeyboardEvent& event ),
  virtualKeyPress      ( IKeyboardEvent& event ),
  characterKeyPress    ( IKeyboardEvent& event ),
  key                  ( IKeyboardEvent& event );

private:
#ifdef IC_WIN
unsigned long
  fKeyStateFlag;
char
  fDiacriticKey;
#endif
}; // IKeyboardHandler

#pragma info(nocpy)

template <class ATarget>
class IKeyboardConnectionTo : public IKeyboardHandler {
typedef IKeyboardHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef bool  (ATarget::* KeyboardMemberFn)( IKeyboardEvent& );

/*------------------------------- Constructors -------------------------------*/
  IKeyboardConnectionTo ( ATarget&           target,
                          KeyboardMemberFn   characterKeyMemberFn );
virtual
 ~IKeyboardConnectionTo ( );

/*-------------------------- Function Registration ---------------------------*/
IKeyboardConnectionTo<ATarget>
 &setVirtualKeyMemberFn  ( KeyboardMemberFn virtualKeyMemberFn );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  virtualKeyPress      ( IKeyboardEvent& event ),
  characterKeyPress    ( IKeyboardEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
KeyboardMemberFn
  fConnectedCharacterKeyMember,
  fConnectedVirtualKeyMember;
}; // IKeyboardConnectionTo

                    
#pragma info(restore)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ikeyhdr.c>

#endif /* _IKEYHDR_ */
