// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 29 1.5.1.4 source/core/collect/ikbtab.h, collection, ioc.v400, 980918 
#ifndef _IKBTAB_
#define _IKBTAB_

#include <ilanglvl.hpp>
#include <iakb.h>
#include <iickb.h>

#include <iivkb.h>

#include <iikbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeyBagAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeyBagAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsTableCursor
                            (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeyBagAsTable :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsTable <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeyBagAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeyBagAsTable
                            (INumber = 100);

           IGKeyBagAsTable
                            (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsTable <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeyBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeyBagAsTable :
  public IGKeyBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeyBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeyBagAsTable <Element, Key> Self;

#define IKeyBagAsTableTypedef(Element, Key)\
  typedef  IKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeyBagAsTable
                            (INumber = 100);

















protected:

           IKeyBagAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeyBagAsTable :
  public IGKeyBagAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeyBagAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeyBagAsTable
                            (INumber = 100);

















protected:

           IVGKeyBagAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeyBagAsTable :
  public IVGKeyBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeyBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeyBagAsTable <Element, Key> Self;

#define IVKeyBagAsTableTypedef(Element, Key)\
  typedef  IVKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeyBagAsTable
                            (INumber = 100);

















protected:

           IVKeyBagAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikbtab.inl>


#pragma info (restore)


#endif // _IKBTAB_
