// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 27 1.5.1.4 source/core/collect/ikblst.h, collection, ioc.v400, 980918 
#ifndef _IKBLST_
#define _IKBLST_

#include <ilanglvl.hpp>
#include <iakb.h>
#include <iickb.h>

#include <iivkb.h>

#include <iikblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeyBagAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeyBagAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsListCursor
                            (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeyBagAsList :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsList <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeyBagAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGKeyBagAsList
                            (INumber = 100);

           IGKeyBagAsList
                            (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsList <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeyBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeyBagAsList :
  public IGKeyBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeyBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeyBagAsList <Element, Key> Self;

#define IKeyBagAsListTypedef(Element, Key)\
  typedef  IKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeyBagAsList
                            (INumber = 100);

















protected:

           IKeyBagAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeyBagAsList :
  public IGKeyBagAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeyBagAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsListTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeyBagAsList
                            (INumber = 100);

















protected:

           IVGKeyBagAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeyBagAsList :
  public IVGKeyBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeyBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeyBagAsList <Element, Key> Self;

#define IVKeyBagAsListTypedef(Element, Key)\
  typedef  IVKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeyBagAsList
                            (INumber = 100);

















protected:

           IVKeyBagAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikblst.inl>


#pragma info (restore)


#endif // _IKBLST_
